/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.remotesupport.inconn;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.remotesupport.inconn.InboundConnectivityBean;
import com.ibm.hsc.remotesupport.inconn.InboundConnectivityConstants;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.rcs.conndata.CecInfo;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class CallBackBean
extends PanelBean
implements InboundConnectivityConstants {
    private static final String TRACE_MASKT = "JRCSCBBT";
    private static final String TRACE_MASKF = "JRCSCBBF";
    private static final String TRACE_MASKD = "JRCSCBBD";
    private static final ClassLogInfo classLogInfo = new ClassLogInfo(-88, -124, "RCS-CBakBean");
    private static long MILLISECONDS_PER_DAY = 86400000L;
    private CecInfo consoleInfo;
    private int unattendedDurationType;
    private Date unattendedTempStarts;
    private Date unattendedTempEnds;
    private boolean m_bAllowUnattended;
    private String m_sModemPhoneNumber;
    private transient String[] m_sDurationTypeSelection;
    private double m_dUnattendedAutoDays;
    private transient Calendar m_cUnattendedTempStart;
    private transient Calendar m_cUnattendedTempEnd;
    private transient Calendar m_cToday;
    private transient double m_dRemainingDays;

    public CallBackBean() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> CallBackBean()");
    }

    public void setAllowUnattended(boolean bl) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKT, (Object)("-> setAllowUnattended(" + bl + ")"));
        this.m_bAllowUnattended = bl;
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKT, (Object)"<- setAllowUnattended()");
    }

    public boolean isAllowUnattended() {
        return this.m_bAllowUnattended;
    }

    public void setModemPhoneNumber(String string) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setModemPhoneNumber(" + string + ")"));
        this.m_sModemPhoneNumber = string;
    }

    public String getModemPhoneNumber() {
        return this.m_sModemPhoneNumber;
    }

    public void setDurationTypeSelection(String[] stringArray) throws IllegalUserDataException {
        if (stringArray != null && stringArray.length > 0) {
            Trace.trace((String)TRACE_MASKT, (Object)("-> setDurationTypeSelection(" + stringArray[0] + ")"));
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)"-> setDurationTypeSelection(none)");
        }
        this.m_sDurationTypeSelection = stringArray;
        this.unattendedDurationType = this.getUnattendedDurationType(stringArray[0]);
        Trace.trace((String)TRACE_MASKT, (Object)"<- setDurationTypeSelection()");
    }

    public String[] getDurationTypeSelection() {
        return this.m_sDurationTypeSelection;
    }

    public void setUnattendedAutoDays(double d) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setUnattendedAutoDays(" + d + ")"));
        this.m_dUnattendedAutoDays = d;
    }

    public double getUnattendedAutoDays() {
        return this.m_dUnattendedAutoDays;
    }

    public void setUnattendedTempStart(Calendar calendar) throws IllegalUserDataException {
        if (calendar != null) {
            Trace.trace((String)TRACE_MASKT, (Object)("-> setUnattendedTempStart(" + calendar.getTime() + ")"));
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)"-> setUnattendedTempStart(none)");
        }
        this.m_cUnattendedTempStart = calendar;
        this.unattendedTempStarts = calendar.getTime();
        Date date = new Date();
        this.m_cToday.setTime(date);
        this.m_dRemainingDays = this.calcTempRemainingDays(date);
        if (this.userTaskManager != null) {
            String string = this.getMountPrefix();
            this.userTaskManager.refreshElement(string + "Today");
            this.userTaskManager.refreshElement(string + "RemainingDays");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- setUnattendedTempStart()");
    }

    public Calendar getUnattendedTempStart() {
        return this.m_cUnattendedTempStart;
    }

    public void setUnattendedTempEnd(Calendar calendar) throws IllegalUserDataException {
        if (calendar != null) {
            Trace.trace((String)TRACE_MASKT, (Object)("-> setUnattendedTempEnd(" + calendar.getTime() + ")"));
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)"-> setUnattendedTempEnd(none)");
        }
        this.m_cUnattendedTempEnd = calendar;
        this.unattendedTempEnds = calendar.getTime();
        Date date = new Date();
        this.m_cToday.setTime(date);
        this.m_dRemainingDays = this.calcTempRemainingDays(date);
        if (this.userTaskManager != null) {
            String string = this.getMountPrefix();
            this.userTaskManager.refreshElement(string + "Today");
            this.userTaskManager.refreshElement(string + "RemainingDays");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- setUnattendedTempEnd()");
    }

    public Calendar getUnattendedTempEnd() {
        return this.m_cUnattendedTempEnd;
    }

    public void setToday(Calendar calendar) throws IllegalUserDataException {
        if (calendar != null) {
            Trace.trace((String)TRACE_MASKT, (Object)("<> setToday(" + calendar.getTime() + ")"));
        } else {
            Trace.trace((String)TRACE_MASKT, (Object)"<> setToday(none)");
        }
        this.m_cToday = calendar;
    }

    public Calendar getToday() {
        return this.m_cToday;
    }

    public void setRemainingDays(double d) throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setRemainingDays(" + d + ")"));
        this.m_dRemainingDays = d;
    }

    public double getRemainingDays() {
        return this.m_dRemainingDays;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> verifyChanges()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- verifyChanges()");
    }

    public void load() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> load()");
        this.m_sDurationTypeSelection = new String[0];
        this.m_cUnattendedTempStart = Calendar.getInstance();
        this.m_cUnattendedTempEnd = Calendar.getInstance();
        this.m_cToday = Calendar.getInstance();
        this.m_dRemainingDays = 0.0;
        Trace.trace((String)TRACE_MASKT, (Object)"<- load()");
    }

    public void save() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> save()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- save()");
    }

    public void setConsoleInfo(CecInfo cecInfo) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setConsoleInfo(" + cecInfo + ")"));
        this.consoleInfo = cecInfo;
    }

    public void setUnattendedDurationType(int n) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setUnattendDurationType(" + n + ")"));
        this.unattendedDurationType = n;
    }

    public int getUnattendedDurationType() {
        return this.unattendedDurationType;
    }

    public void setUnattendTempStarts(Date date) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setUnattendTempStarts(" + date + ")"));
        this.unattendedTempStarts = date;
    }

    public Date getUnattendTempStarts() {
        return this.unattendedTempStarts;
    }

    public void setUnattendTempEnds(Date date) {
        Trace.trace((String)TRACE_MASKT, (Object)("<> setUnattendedTempEnds(" + date + ")"));
        this.unattendedTempEnds = date;
    }

    public Date getUnattendTempEnds() {
        return this.unattendedTempEnds;
    }

    public void prepare() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> prepare()");
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace((String)TRACE_MASKT, (Object)"<- prepare()");
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> panelAction(" + taskActionEvent + ")"));
        try {
            String string = taskActionEvent.getElementName();
            if (string.endsWith("PrepareButton")) {
                PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                panelTaskletRequest.setSource((Object)"CallBackBean");
                panelTaskletRequest.setData("Source", (Object)"CallBackPanel");
                panelTaskletRequest.setData("Command", (Object)"OpenSessionPanel");
                panelTaskletRequest.setData("ConsoleInfo", (Object)this.consoleInfo);
                this.postTaskletRequest(panelTaskletRequest);
            } else if (string.endsWith("ResetButton")) {
                Date date = new Date();
                this.m_cUnattendedTempStart.setTime(date);
                this.unattendedTempStarts = this.m_cUnattendedTempStart.getTime();
                this.m_cUnattendedTempEnd.setTime(date);
                this.m_cUnattendedTempEnd.add(5, 7);
                this.unattendedTempEnds = this.m_cUnattendedTempEnd.getTime();
                this.m_cToday.setTime(date);
                this.setRemainingDays(this.calcTempRemainingDays(date));
                this.updateUTMElements();
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Unknown element");
            }
        }
        catch (RuntimeException runtimeException) {
            new AusMicrocodeLog(classLogInfo, 5, runtimeException).writeEntryFromTaskletClient();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- panelAction()");
    }

    public void parentalAction(TaskActionEvent taskActionEvent, PanelBean panelBean) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> parentalAction(" + taskActionEvent + ")"));
        try {
            String string = taskActionEvent.getActionCommand();
            if (string == null) {
                string = "";
            }
            Trace.trace((String)TRACE_MASKF, (Object)("command=" + string));
            if (string.equals("")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
            } else if (string.endsWith("ParentalValidate")) {
                if (this.m_bAllowUnattended && this.m_dRemainingDays > 28.0) {
                    Integer n = new Integer(28);
                    String string2 = "MAX_UNATTENDED_DAYS";
                    LocalizableText localizableText = new LocalizableText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", string2 + ".TITLE");
                    Object[] objectArray = new Object[]{n, n};
                    MessageText messageText = new MessageText("com.ibm.hwmca.fw.rcs.inconn.res.InboundConnMsgs", string2 + ".MSG", objectArray);
                    Object[] objectArray2 = new Object[]{localizableText, messageText};
                    ((InboundConnectivityBean)panelBean).setValidateErrorMsgInfo(objectArray2);
                }
            } else if (string.endsWith("ParentalCommit")) {
                try {
                    PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                    panelTaskletRequest.setSource((Object)"CallBackBean");
                    panelTaskletRequest.setData("Source", (Object)"CallBackPanel");
                    panelTaskletRequest.setData("Command", (Object)"Commit");
                    panelTaskletRequest.setData("Bean", (Object)this);
                    this.postTaskletRequest(panelTaskletRequest);
                }
                catch (IllegalUserDataException illegalUserDataException) {}
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
            }
        }
        catch (RuntimeException runtimeException) {
            new AusMicrocodeLog(classLogInfo, 5, runtimeException).writeEntryFromTaskletClient();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- parentalAction()");
    }

    public void update(Object object) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> update()");
        try {
            HashMap hashMap = (HashMap)object;
            String string = (String)hashMap.get("Command");
            if (string == null) {
                string = "";
            }
            Trace.trace((String)TRACE_MASKF, (Object)("command=" + string));
            if (string.equals("")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
            } else {
                Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
            }
        }
        catch (RuntimeException runtimeException) {
            new AusMicrocodeLog(classLogInfo, 5, runtimeException).writeEntryFromTaskletClient();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- update()");
    }

    private void updateDataBeanInfo(boolean bl) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> updateDataBeanInfo(" + bl + ")"));
        if (bl) {
            Date date = new Date();
            String string = "";
            if (this.userTaskManager != null) {
                string = this.getMountPrefix();
            }
            this.m_sDurationTypeSelection = new String[]{string + this.getDurationTypeSelection(this.unattendedDurationType)};
            if (this.m_dUnattendedAutoDays <= 0.0) {
                this.m_dUnattendedAutoDays = 7.0;
            }
            if (this.unattendedTempStarts != null) {
                this.m_cUnattendedTempStart.setTime(this.unattendedTempStarts);
            } else {
                this.m_cUnattendedTempStart.setTime(date);
                this.unattendedTempStarts = this.m_cUnattendedTempStart.getTime();
            }
            if (this.unattendedTempEnds != null) {
                this.m_cUnattendedTempEnd.setTime(this.unattendedTempEnds);
            } else {
                this.m_cUnattendedTempEnd.setTime(date);
                this.m_cUnattendedTempEnd.add(5, 7);
                this.unattendedTempEnds = this.m_cUnattendedTempEnd.getTime();
            }
            this.m_cToday.setTime(date);
            this.setRemainingDays(this.calcTempRemainingDays(date));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> updateUTMElements()");
        if (this.userTaskManager != null) {
            String string = this.getMountPrefix();
            if (this.m_sDurationTypeSelection.length >= 1) {
                if (this.m_sDurationTypeSelection[0].endsWith("Continuous")) {
                    this.userTaskManager.setSelected(string + "Continuous", true);
                } else if (this.m_sDurationTypeSelection[0].endsWith("Automatic")) {
                    this.userTaskManager.setSelected(string + "Automatic", true);
                } else {
                    this.userTaskManager.setSelected(string + "Temporary", true);
                }
            }
            if (this.m_bAllowUnattended) {
                this.userTaskManager.setEnabled(string + "ModemPhoneNumber", true);
                this.userTaskManager.setEnabled(string + "DurationGroup", true);
                this.userTaskManager.setEnabled(string + "Continuous", true);
                this.userTaskManager.setEnabled(string + "Automatic", true);
                this.userTaskManager.setEnabled(string + "Temporary", true);
            } else {
                this.userTaskManager.setEnabled(string + "ModemPhoneNumber", false);
                this.userTaskManager.setEnabled(string + "DurationGroup", false);
                this.userTaskManager.setEnabled(string + "Continuous", false);
                this.userTaskManager.setEnabled(string + "Automatic", false);
                this.userTaskManager.setEnabled(string + "Temporary", false);
            }
            this.userTaskManager.refreshElement(string + "ModemPhoneNumber");
            this.userTaskManager.refreshElement(string + "DurationGroup");
            this.userTaskManager.refreshElement(string + "Automatic");
            this.userTaskManager.refreshElement(string + "Temporary");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- updateUTMElements()");
    }

    private String getDurationTypeSelection(int n) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> getDurationTypeSelection(" + n + ")"));
        String string = "Continuous";
        if (n != 0) {
            if (n == 1) {
                string = "Automatic";
            } else if (n == 2) {
                string = "Temporary";
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- getDurationTypeSelection() " + string));
        return string;
    }

    private int getUnattendedDurationType(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> getUnattendedDurationType(" + string + ")"));
        int n = 0;
        if (!string.endsWith("Continuous")) {
            if (string.endsWith("Automatic")) {
                n = 1;
            } else if (string.endsWith("Temporary")) {
                n = 2;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- getUnattendedDurationType() " + n));
        return n;
    }

    private double calcTempRemainingDays(Date date) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> calcTempRemainingDays(" + date + ")"));
        double d = 0.0;
        if (!this.unattendedTempStarts.after(this.unattendedTempEnds)) {
            if (date.before(this.unattendedTempStarts) || date.equals(this.unattendedTempStarts)) {
                long l = this.unattendedTempStarts.getTime();
                long l2 = this.unattendedTempEnds.getTime();
                d = ((double)l2 - (double)l) / (double)MILLISECONDS_PER_DAY;
            } else if (date.before(this.unattendedTempEnds)) {
                long l = date.getTime();
                long l3 = this.unattendedTempEnds.getTime();
                d = ((double)l3 - (double)l) / (double)MILLISECONDS_PER_DAY;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)("<- calcTempRemainingDays() " + d));
        return d;
    }
}

